require "prefabutil"

local assets=
{
	Asset( "ANIM", "anim/military_skat.zip" ),
	Asset("ANIM", "anim/militaryskat.zip"),
	Asset("IMAGE", "images/inventoryimages/military_skat.tex"),
	Asset("ATLAS", "images/inventoryimages/military_skat.xml"),
}

local prefabs =
{
	"militaryskat",
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
end

local function nightvision(inst)
	if inst:HasTag("nightonlyvision") and (GetClock():IsNight() or GetWorld():IsCave() or GetClock():IsDusk()) then
		GetClock():SetNightVision(true)
		GetWorld().components.colourcubemanager:SetOverrideColourCube("images/colour_cubes/mole_vision_on_cc.tex", 2)
		else
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
	end
end

local function removenightvision(inst)
		GetClock():SetNightVision(false)
		GetWorld().components.colourcubemanager:SetOverrideColourCube(nil, .5)
end

local function ChangeInsulationSW(inst)
if  GetWorld().components.seasonmanager.current_season == SEASONS.DRY then
    inst.components.insulator:SetSummer()
elseif not GetWorld().components.seasonmanager.current_season == SEASONS.DRY then
 	inst.components.insulator:SetWinter()
    end end	


local function ChangeInsulation(inst)
if GetWorld().components.seasonmanager.current_season == SEASONS.SUMMER then
    inst.components.insulator:SetSummer()
elseif not GetWorld().components.seasonmanager.current_season == SEASONS.WINTER then
 	inst.components.insulator:SetWinter()
    end end	

local function onequip(inst, owner) 
    inst:ListenForEvent("blocked", OnBlocked, owner)
	owner:AddTag("antirad")
	ChangeInsulation(inst)
inst:AddTag("nightonlyvision")
	if owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale - .5
	end
	
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function onunequip(inst, owner) 
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	inst:DoTaskInTime(0, removenightvision, nil, owner)
	owner:RemoveTag("antirad")
	inst:RemoveTag("nightonlyvision")
	if owner.components.health then
		owner.components.health.fire_damage_scale = owner.components.health.fire_damage_scale + .5
	end
	
	if owner:HasTag("rad") then
	inst.task = inst:DoPeriodicTask(4, hurtowner, nil, owner)
	end
end



local function fnab()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
        	
    inst.AnimState:SetBank("military_skat")
    inst.AnimState:SetBuild("military_skat")
    inst.AnimState:PlayAnimation("idle", false)
	
	MakeInventoryPhysics(inst)
     	
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/marblearmour"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/military_skat.xml"
    
    inst:AddComponent("armor")
    	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	inst.components.equippable.insulated = true
	inst.components.inventoryitem.keepondeath = true
	
	inst:DoPeriodicTask(3, nightvision, nil, inst)
	
	if IsDLCEnabled(REIGN_OF_GIANTS) then
	inst.components.armor:InitCondition(2000, 0.8)
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_SMALL)
	ChangeInsulation(inst)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	
	elseif IsDLCEnabled(0002) then
	inst.components.armor:InitCondition(2000, 0.8)
	
	inst:AddComponent("insulator")
	inst.components.insulator:SetInsulation(TUNING.INSULATION_SMALL)
	ChangeInsulationSW(inst)
	
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_MED)
	
	
	inst.components.equippable.poisonblocker = true
	inst.components.equippable.poisongasblocker = true
	end
	
    return inst
end

STRINGS.RECIPE_DESC.MILITARY_SKAT = "Repair your suit\ncompletely."

return Prefab( "common/inventory/military_skat", fnab, assets) 